/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.graph.Renderer;
import org.das2.graph.StackedHistogramRenderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class StackedHistogramStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    BindingGroup elementBindingContext;
    Renderer renderer;
    public static final String PROP_CONTROL = "control";
    String control;
    EnumerationEditor peaksIndicatorEditor;
    private JLabel jLabel1;
    private JPanel peaksIndicatorPanel;

    public StackedHistogramStylePanel() {
        this.initComponents();
        this.peaksIndicatorEditor = new EnumerationEditor();
        this.peaksIndicatorEditor.setValue((Object)StackedHistogramRenderer.PeaksIndicator.GrayPeaks);
        this.peaksIndicatorPanel.add(this.peaksIndicatorEditor.getCustomEditor());
        this.revalidate();
        this.peaksIndicatorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StackedHistogramStylePanel.this.update();
            }
        });
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("peaksIndicator", this.peaksIndicatorEditor.getAsText());
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    public String getControl() {
        return "peaksIndicator=" + this.peaksIndicatorEditor.getValue().toString();
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.peaksIndicatorPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Stacked Histogram")));
        this.jLabel1.setText("Peaks Indicator:");
        this.peaksIndicatorPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.peaksIndicatorPanel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 265, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.peaksIndicatorPanel, -2, -1, -2).addContainerGap(233, Short.MAX_VALUE)));
    }

    private void updateGUI(Renderer renderer) {
        this.control = renderer.getControl();
        if (renderer.hasControl("peaksIndicator")) {
            String v = renderer.getControl("peaksIndicator", "GreyPeaks");
            this.peaksIndicatorEditor.setAsText(v);
        }
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }
}

